'use strict';

/* --------------------------------------------------------------
   klarnaosmproduct.js 2022-06-01
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2022 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

klarnaosm.widgets.module('klarnaosmproduct', [gambio.source + '/libs/events'], function (data) {
    'use strict';

    // ########## VARIABLE INITIALIZATION ##########

    var $this = $(this),
        defaults = {},
        options = $.extend(true, {}, defaults, data),
        module = {};

    module.init = function (done) {
        if (typeof $ !== 'undefined' && typeof jse !== 'undefined') {
            $(window).on(jse.libs.theme.events.STICKYBOX_CONTENT_CHANGE(), function () {
                var kosmPrice = document.getElementById('kosm_price');
                if (kosmPrice === null) {
                    return;
                }
                var kosmPriceData = JSON.parse(kosmPrice.textContent),
                    price = kosmPriceData.price;
                document.querySelectorAll('div.klarnaosm klarna-placement').forEach(function (e) {
                    e.dataset.purchaseAmount = price;
                });

                window.KlarnaOnsiteService = window.KlarnaOnsiteService || [];
                window.KlarnaOnsiteService.push({ eventName: 'refresh-placements' });
            });
        }
        done();
    };

    return module;
});
//# sourceMappingURL=data:application/json;charset=utf8;base64,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
